#!/bin/sh
#
# $Id$
#
# Copyright 2017, Juniper Networks, Inc
# All Rights Reserved
#

# deal with downgrade to older releases

if test -s /usr/libexec/pkg_funcs.sh; then
    . /usr/libexec/pkg_funcs.sh
else
    # this is what we need
    get_xmltags() {
        local xmlf=$1; shift
        local e x

        test -d ${xmlf:-/dev/null} && xmlf=$xmlf/package.xml
        if test -s ${xmlf:-/dev/null}; then
            e="$1"; shift
            for x in "$@"
            do
                e="$e|$x"
	    done
            # extract the patterns
            # we can handle up to three - in tag name
            # which will be converted to _
            eval `egrep "<($e)>" $xmlf 2> /dev/null |
            sed -e 's,</.*,,;s,<,,;s,/>,=1,;s,>,=,' \
              -e '/^[^=]*-/s,-,_,' \
              -e '/^[^=]*-/s,-,_,' \
              -e '/^[^=]*-/s,-,_,'`
	fi
    }
fi

case ",$DEBUG_SH," in
*,downgrade*|*,pkg:downgrade*) set -x;;
esac

DOWNGRADE_SET=${DOWNGRADE_SET:-active}

case "$DOWNGRADE_SET" in
legacy) exit 0;;		# nothing for us
esac

get_xmltags $PKGSETS/$DOWNGRADE_SET/os-runtime version sub-optional "feature-.*"

if test -z "$sub_optional" -a ${version:-0} -lt 20161207; then
    # depending on what we are downgrading to, we may run more than once
    if test -d $PKGSETS/$DOWNGRADE_SET/optional; then
        # make sure optional is in $PKGSETS
        mkdir -p $PKGSETS/optional
        mv $PKGSETS/$DOWNGRADE_SET/optional/* $PKGSETS/optional
        rm -rf $PKGSETS/$DOWNGRADE_SET/optional
    fi
fi
if test -z "$feature_veriexec_extlate"; then
    # these can be dangerous
    rm -f /usr/libexec/veriexec-ext.so.1 /usr/libexec/veriexec/*
fi
if test -z "$feature_loader_manifest"; then
    # cleanup any trace of loader-manifest if necessary
    if egrep -q '(^loader|/loader) ' /boot/manifest; then
	rm -f /boot/loader-manifest* /boot/veloader
    fi
    # take care of oam too
    if test -c /dev/gpt/oam; then
	fsck_ufs -y /dev/gpt/oam
	mount /dev/gpt/oam /oam
	if egrep -q '(^loader|/loader) ' /oam/boot/manifest; then
	    rm -f /oam/boot/loader-manifest* /oam/boot/veloader
	fi
	umount /oam
    fi
fi
if test -z "$feature_media_noauto"; then
    fstab=/etc/fstab
    # remove any noauto entries from fstab
    # double check that rc.d/media does not handle noauto
    if grep -q ,noauto $fstab &&
	    grep -q 'read.*_eol' /etc/rc.d/media; then
	sed -n '/,noauto/s,^/[^[:space:]]*[[:space:]]*\([^[:space:]]*\).*,\1,p' $fstab |
	    while read m
	    do
		test -d $m && umount $m
	    done > /dev/null 2>&1
	sed -i.bak '/,noauto/d' $fstab
    fi
fi
