#!/bin/sh
#
# $Id$
#
# Copyright 2018, Juniper Networks, Inc
# All Rights Reserved
#

# just in case
set_flags() { : ; }

# this will be here during normal boot
# which is what we care about
if test -s /usr/libexec/pkg_funcs.sh; then
    # check critical symlinks
    . /usr/libexec/pkg_funcs.sh

    for p in /sbin/veriexec
    do
	make_symlink /packages/mnt/os-runtime$p $p
    done
    # we want this symlink if the file does not exist
    test -s /etc/ttys.sys ||
	make_symlink /packages/mnt/os-runtime/etc/ttys /etc/ttys.sys

    # set up symlinks pointing to initial configs if /.mount/root is not a
    # symlink, and /.mount is a writable mountpoint.
    #
    # this is done in such way as some setups (in particular VMHost setups)
    # move the /root directory to another file system and set up a symlink
    # instead, which means access to /root/* is only available in the later phase
    # of system boot.
    if test ! -L /.mount/root -a -w /.mount; then
	for p in .cshrc .login .profile
	do
	    test -s /.mount/root/$p -o -L /.mount/root/$p ||
		make_symlink /packages/mnt/os-runtime/root/$p /root/$p
	done
    fi
fi
