#!/bin/sh
#
# $Id$
#
# Copyright 2014, Juniper Networks, Inc
# All Rights Reserved
#

. $PKGTOOLS/pkg_subr.sh
. $PKGTOOLS/pkg_mount.sh

case "${1:-activate}" in
deact*) exit 0;;
activ*) mkdir -p /var/jail
    for p in jail-runtime php-base; do
        test -d $PKGSETS/active/$p || pkg add -v $p
    done
   ;;
mounted*)
    mkdir -p /var/jail
    if [ -n "$PKGMNT" ]; then
        rm -rf /jail
        ln -sf $PKGMNT/jail /jail
        mpost=$PKGMNT/mount.post
        if [ -x $mpost ]; then
            $mpost $PKGMNT
        fi
    fi

    jailexapp='/jail/var/jweb-app/jweb-ex-app'
    if [ -d $jailexapp ]; then
        rm -rf $jailexapp > /dev/null
    fi

    jailapp='/jail/var/jweb-app'
    if [ ! -d $jailapp ]; then
        mkdir -m 0755 -p $jailapp > /dev/null
    fi
    ;;
unmount*)
    upre=$PKGMNT/umount.pre
    if [ -x $upre ]; then
        # we may be called more than once
        n=`mount | grep -c $PKGMNT/`
        if [ $n -gt 0 ]; then
            $upre $PKGMNT
        fi
    fi
    ;;
esac
